TITLE   'Helmholtz Coil, Force' 				       { exa133a.pde }
SELECT     errlim=1e-3   ngrid=1     spectral_colors	
COORDINATES   ycylinder( 'r', 'z')
VARIABLES   A_phi
DEFINITIONS
   r1=0.15     r2=0.25     z0=0.05     d0=0.1     L=1.0
   mu0=4*pi*1e-7     mu=mu0     J_phi
   Br=-dz(A_phi)     Bz=1/r*dr(r*A_phi)
   B=vector( Br, Bz)     Bm=magnitude( B)
   Hr=Br/mu     Hz=Bz/mu     H=B/mu     Hm=Bm/mu
   mesh_spacing=0.1*d0*(1+(r/d0)^2+(z/d0)^2)	{ Maximum size }
   area=(r2-r1)*2*z0   J0=1.0		{ Cross-sectional area and current }
EQUATIONS
   dz( Hr)- dr( Hz)=J_phi
BOUNDARIES
region 'domain'  J_phi=0				
   start(0,-L) value(A_phi)=0 line to (2*L,-L) to (2*L,L)  to (0,L) close
region 'coil1' J_phi=1.0					
   start(r1,-d0-z0) line to (r2,-d0-z0) to (r2,-d0+z0) to (r1,-d0+z0) close
region 'coil2' J_phi=1.0		
   start(r1,d0-z0) line to (r2,d0-z0) to (r2,d0+z0) to (r1,d0+z0) close
PLOTS
summary
   report( vol_integral( J_phi*Bz,  'coil2'))  as 'Radial force, integrated'
   report( vol_integral( -J_phi*Br, 'coil2')) as 'Axial force on coil 2'
   report( -2*pi*(r1+r2)/2* mu*(J0*area)/(2*pi*2*d0)* (J0*area))
      as 'Estimate'			{ Length*current*mu/2/pi*current/distance }
END




